﻿using System;

namespace InsideTheExceptionClass
{
    class Tester
    {
        public void Run()
        {
            try
            {
                Console.WriteLine("Tu otwórz plik");
                double a = 12;
                double b = 0;
                Console.WriteLine("{0} / {1} = {2}", a, b, DoDivide(a, b));
                Console.WriteLine("Ta linijka może zostać wydrukowana albo i nie");
            }
            // najpierw najbardziej charakterystyczny wyjątek
            catch (DivideByZeroException e)
            {
                Console.WriteLine("\nDivideByZeroException! Msg: {0}", e.Message);
                Console.WriteLine("\nHelpLink: {0}", e.HelpLink);
                Console.WriteLine("\nOto ślad stosu: {0}\n", e.StackTrace);
            }
            catch
            {
                Console.WriteLine("Przechwycono nieznany wyjątek");
            }
            finally
            {
                Console.WriteLine("Tu zamknij plik");
            }
        }
        // wykonaj dzielenie, jeśli jest dopuszczalne
        public double DoDivide(double a, double b)
        {
            if (b == 0)
            {
                DivideByZeroException e = new DivideByZeroException();
                e.HelpLink = "http://www.libertyassociates.com";
                throw e;
            }
            if (a == 0)
                throw new ArithmeticException();
            return a / b;
        }

        static void Main()
        {
            Console.WriteLine("Wejście w Main()...");
            Tester t = new Tester();
            t.Run();
            Console.WriteLine("Wyjście z Main()...");
        }
    }
}